/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.glacialhunter;

import com.github.teamfusion.rottencreatures.client.registries.RCSoundEvents;
import com.github.teamfusion.rottencreatures.common.level.entities.glacialhunter.HunterWolf;
import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import com.github.teamfusion.rottencreatures.common.registries.RCEntityTypes;
import com.github.teamfusion.rottencreatures.common.registries.RCItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.animal.WolfVariants;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GlacialHunter
extends Zombie {
    public GlacialHunter(EntityType<? extends Zombie> type, Level level) {
        super(type, level);
        this.xpReward = 6;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.createAttributes().add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ARMOR, 4.0);
    }

    protected void addBehaviourGoals() {
        super.addBehaviourGoals();
        this.targetSelector.addGoal(1, (Goal)new ZombieAttackGoal((Zombie)this, 1.0, false));
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.hasSpear()) {
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(6.0);
            this.getAttribute(Attributes.ATTACK_KNOCKBACK).setBaseValue(1.5);
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        if (this.level().getRandom().nextFloat() <= 0.4f) {
            this.setSpear();
        }
    }

    public boolean hasSpear() {
        return this.getItemBySlot(EquipmentSlot.MAINHAND).is(RCItems.SPEAR.get());
    }

    private void setSpear() {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)RCItems.SPEAR.get()));
    }

    protected float getEquipmentDropChance(EquipmentSlot slot) {
        return this.getItemBySlot(slot).is(RCItems.SPEAR.get()) ? 0.0f : super.getEquipmentDropChance(slot);
    }

    public boolean doHurtTarget(Entity entity) {
        boolean hurtTarget = super.doHurtTarget(entity);
        if (hurtTarget && this.getMainHandItem().isEmpty() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float modifier = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 140 * (int)modifier), (Entity)this);
        }
        return hurtTarget;
    }

    protected ItemStack getSkull() {
        return new ItemStack((ItemLike)RCBlocks.GLACIAL_HUNTER_HEAD.get());
    }

    protected boolean isSunSensitive() {
        return false;
    }

    public boolean isBaby() {
        return false;
    }

    public void setBaby(boolean baby) {
    }

    public void travel(Vec3 vec3) {
        this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * (this.hasSpear() ? 1.5f : 1.0f));
        super.travel(vec3);
    }

    public static boolean checkGlacialHunterSpawnRules(EntityType<GlacialHunter> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return GlacialHunter.checkMonsterSpawnRules(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || level.canSeeSky(pos));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        HunterWolf wolf = (HunterWolf)RCEntityTypes.HUNTER_WOLF.get().create(this.level());
        if (level.getRandom().nextFloat() <= 0.3f && spawnType == MobSpawnType.NATURAL && wolf != null) {
            wolf.moveTo(this.blockPosition().offset(-2 + this.level().random.nextInt(3), 1, -2 + this.level().random.nextInt(3)), 0.0f, 0.0f);
            wolf.setOwner((LivingEntity)this);
            Registry variants = level.registryAccess().registryOrThrow(Registries.WOLF_VARIANT);
            wolf.setVariant((Holder)variants.getHolder(WolfVariants.DEFAULT).orElseThrow());
            level.addFreshEntity((Entity)wolf);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, groupData);
    }

    protected SoundEvent getAmbientSound() {
        return RCSoundEvents.GLACIAL_HUNTER_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return RCSoundEvents.GLACIAL_HUNTER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return RCSoundEvents.GLACIAL_HUNTER_DEATH.get();
    }
}

